Imports System
Imports System.Runtime.Serialization
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.IO
Imports System.Collections

'
' Instances of this class model the state of a game.
' Each game will use only one instance of this class, which it will get
' by calling this class' getGameModel method.
'
<Serializable()> Public Class GameModel
    Private Shared theInstance As New GameModel()
    Private mementoManager As MilestoneMementoManager

    ' This constructor is private to force other classes to call this
    ' class's GetGameModel method to get an instance of it.
    Private Sub New()
        mementoManager = New MilestoneMementoManager(Me)
    End Sub 'New


    '
    ' This method returns the single instance of this class that other
    ' classes will use.
    '
    Public Shared Function GetGameModel() As GameModel
        Return theInstance
    End Function

    '
    ' Restore this object's state from the given memento object.
    '
    Public Sub RestoreFromMemento(ByVal memento As IMilestoneMemento)
        Dim m As MilestoneMemento = CType(memento, MilestoneMemento)
        mementoManager = m.MementoManager
    End Sub

    '
    ' Create a memento object that encapsulates a snapshot of this object's
    ' state.
    '
    Public Function CreateMemento(ByVal description As String) As IMilestoneMemento
        ' Create a memento object and set its instance variables
        Dim memento As New MilestoneMemento(description)
        memento.MementoManager = mementoManager
        Return memento
    End Function
End Class 'GameModel 
